/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.parsing.ast;

import beaver.Symbol;
import com.aptana.core.util.ArrayUtil;
import com.aptana.editor.html.parsing.HTMLParserConstants;
import com.aptana.editor.html.parsing.ast.HTMLNode;
import com.aptana.parsing.ast.INameNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseNodeAttribute;
import com.aptana.parsing.ast.ParseNode;
import com.aptana.parsing.ast.ParseNodeAttribute;
import com.aptana.parsing.lexer.IRange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLElementNode
extends HTMLNode {
    private static final String ID = "id";
    private static final String CLASS = "class";
    private final String fTag;
    private int fStartNodeOffset;
    private int fStartNodeEnd;
    private int fEndNodeOffset;
    private int fEndNodeEnd;
    private Map<String, IParseNodeAttribute> fAttributes;
    private ArrayList<IParseNode> fCSSStyleNodes;
    private ArrayList<IParseNode> fJSAttributeNodes;
    private boolean fIsSelfClosing;

    public HTMLElementNode(Symbol tagSymbol, int start, int end) {
        this(tagSymbol, HTMLParserConstants.NO_HTML_NODES, start, end);
    }

    public HTMLElementNode(Symbol tagSymbol, HTMLNode[] children, int start, int end) {
        super((short)2, children, start, end);
        String tag = tagSymbol.value.toString();
        if (tag.length() > 0) {
            try {
                if (tag.endsWith("/>")) {
                    tag = HTMLElementNode.getTagName(tag.substring(1, tag.length() - 2));
                    this.fIsSelfClosing = true;
                } else {
                    tag = HTMLElementNode.getTagName(tag.substring(1, tag.length() - 1));
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        this.fTag = tag;
        this.fStartNodeOffset = tagSymbol.getStart();
        this.fStartNodeEnd = tagSymbol.getEnd();
    }

    public void trimToSize() {
        super.trimToSize();
        if (this.fCSSStyleNodes != null) {
            this.fCSSStyleNodes.trimToSize();
        }
        if (this.fJSAttributeNodes != null) {
            this.fJSAttributeNodes.trimToSize();
        }
    }

    public void addOffset(int offset) {
        this.fStartNodeOffset += offset;
        this.fStartNodeEnd += offset;
        super.addOffset(offset);
    }

    public void addCSSStyleNode(IParseNode node) {
        if (this.fCSSStyleNodes == null) {
            this.fCSSStyleNodes = new ArrayList(3);
        }
        this.fCSSStyleNodes.add(node);
    }

    public void addJSAttributeNode(IParseNode node) {
        if (this.fJSAttributeNodes == null) {
            this.fJSAttributeNodes = new ArrayList(3);
        }
        this.fJSAttributeNodes.add(node);
    }

    public String getName() {
        return this.fTag;
    }

    public String getElementName() {
        return this.getName();
    }

    public INameNode getNameNode() {
        return new ParseNode.NameNode(this.fTag, this.fStartNodeOffset, this.fStartNodeEnd);
    }

    public IParseNode getNodeAtOffset(int offset) {
        IParseNode result = super.getNodeAtOffset(offset);
        if (result == this && this.fJSAttributeNodes != null) {
            for (IParseNode node : this.fJSAttributeNodes) {
                if (!node.contains(offset)) continue;
                result = node.getNodeAtOffset(offset);
                break;
            }
        }
        if (result == this && this.fCSSStyleNodes != null) {
            for (IParseNode node : this.fCSSStyleNodes) {
                if (!node.contains(offset)) continue;
                result = node.getNodeAtOffset(offset);
                break;
            }
        }
        return result;
    }

    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append(this.getName());
        List<String> attributes = HTMLElementNode.getAttributesToShow();
        for (String attribute : attributes) {
            IParseNodeAttribute value;
            if (ID.equals(attribute)) {
                String id = this.getID();
                if (id == null) continue;
                text.append('#').append(id);
                continue;
            }
            if (CLASS.equals(attribute)) {
                String cssClass = this.getCSSClass();
                if (cssClass == null) continue;
                text.append('.').append(cssClass);
                continue;
            }
            if (this.fAttributes == null || (value = this.fAttributes.get(attribute)) == null) continue;
            text.append(' ').append(value.getValue());
        }
        return text.toString();
    }

    public String getID() {
        return this.getAttributeValue(ID);
    }

    public String getCSSClass() {
        return this.getAttributeValue(CLASS);
    }

    public String getAttributeValue(String name) {
        if (this.fAttributes == null) {
            return null;
        }
        IParseNodeAttribute attr = this.fAttributes.get(name);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public void setAttribute(String name, String value, IRange nameRegion, IRange valueRegion) {
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap<String, IParseNodeAttribute>(2);
        }
        this.fAttributes.put(name, (IParseNodeAttribute)new ParseNodeAttribute((IParseNode)this, name, value, nameRegion, valueRegion));
    }

    public INameNode getEndNode() {
        return new ParseNode.NameNode(this.fTag, this.fEndNodeOffset, this.fEndNodeEnd);
    }

    public void setEndNode(int start, int end) {
        this.fEndNodeOffset = start;
        this.fEndNodeEnd = end;
    }

    public IParseNode[] getCSSStyleNodes() {
        if (this.fCSSStyleNodes == null) {
            return HTMLParserConstants.NO_PARSE_NODES;
        }
        return this.fCSSStyleNodes.toArray(new IParseNode[this.fCSSStyleNodes.size()]);
    }

    public IParseNode[] getJSAttributeNodes() {
        if (this.fJSAttributeNodes == null) {
            return HTMLParserConstants.NO_PARSE_NODES;
        }
        return this.fJSAttributeNodes.toArray(new IParseNode[this.fJSAttributeNodes.size()]);
    }

    public boolean isSelfClosing() {
        return this.fIsSelfClosing;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof HTMLElementNode)) {
            return false;
        }
        HTMLElementNode other = (HTMLElementNode)((Object)obj);
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.fAttributes == null || other.fAttributes == null) {
            return this.fAttributes == other.fAttributes;
        }
        return this.fAttributes.equals(other.fAttributes);
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + this.getName().hashCode();
        hash = 31 * hash + (this.fAttributes != null ? this.fAttributes.hashCode() : 1);
        return hash;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        String name = this.getName();
        if (name.length() > 0) {
            IParseNode[] children;
            text.append('<').append(name);
            if (this.fAttributes != null) {
                for (IParseNodeAttribute attr : this.fAttributes.values()) {
                    text.append(' ').append(attr.getName()).append("=\"").append(attr.getValue()).append('\"');
                }
            }
            text.append('>');
            IParseNode[] iParseNodeArray = children = this.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IParseNode child = iParseNodeArray[n2];
                text.append(child);
                ++n2;
            }
            text.append("</").append(name).append('>');
        }
        return text.toString();
    }

    private static String getTagName(String tag) {
        StringTokenizer token = new StringTokenizer(tag);
        return token.nextToken();
    }

    private static List<String> getAttributesToShow() {
        String value = Platform.getPreferencesService().getString("com.aptana.editor.html", "HTML_OUTLINE_TAG_ATTRIBUTES", "", null);
        StringTokenizer st = new StringTokenizer(value);
        ArrayList<String> attributes = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            attributes.add(st.nextToken());
        }
        return attributes;
    }

    public IParseNodeAttribute[] getAttributes() {
        if (this.fAttributes == null) {
            return ParseNode.NO_ATTRIBUTES;
        }
        return this.fAttributes.values().toArray(new IParseNodeAttribute[this.fAttributes.size()]);
    }

    public IParseNodeAttribute getAttributeAtOffset(int offset) {
        Object[] attrs = this.getAttributes();
        if (ArrayUtil.isEmpty((Object[])attrs)) {
            return null;
        }
        Object[] objectArray = attrs;
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            Object attr = objectArray[n2];
            IRange nameRange = attr.getNameRange();
            if (nameRange != null && nameRange.contains(offset)) {
                return attr;
            }
            IRange valueRange = attr.getValueRange();
            if (valueRange != null && valueRange.contains(offset)) {
                return attr;
            }
            ++n2;
        }
        return null;
    }
}

